---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：47-kubeadm reset

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **CleanupNodeフェーズの具体的な削除対象**：phases/reset/ディレクトリは未読

## 2) 参照した情報（Evidence一覧）

- E-01: `cmd/kubeadm/app/cmd/reset.go` - resetコマンド本体
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 3つのフェーズが登録される | E-01 行242-244 | ○ |
| C-02 | --forceで確認なしリセット | E-01 行195-197 | ○ |
| C-03 | --dry-runでシミュレーション可能 | E-01 行199-202, 119-132 | ○ |
| C-04 | --cleanup-tmp-dirで一時ディレクトリクリーンアップ | E-01 行203-206 | ○ |
| C-05 | 手動クリーンアップ案内メッセージを表示 | E-01 行51-58, 235 | ○ |
| C-06 | CRIソケット解決は3段階 | E-01 行322-332 resetDetectCRISocket | ○ |
| C-07 | 証明書ディレクトリの解決順序 | E-01 行165-172 | ○ |
| C-08 | kubeconfig読み込み失敗でも続行 | E-01 行134-145 | ○ |
| C-09 | ConfigMap取得失敗でも警告のみ | E-01 行140-142 | ○ |
| C-10 | DryRunモードでフェイクClient使用 | E-01 行120-125 | ○ |
| C-11 | 関連機能118-クラスター初期化が遷移先機能 | E-03 画面No47 | ○ |
| C-12 | 関連機能121-証明書管理が補助機能 | E-03 画面No47 | ○ |
| C-13 | resetOptions構造体の定義 | E-01 行62-68 | ○ |
| C-14 | CleanupNodeフェーズの具体的な削除内容 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- phases/reset/ディレクトリ内のCleanupNodeフェーズ実装は未読のため、具体的に何が削除されるかの詳細は未確認
  - 候補：phases/reset/cleanupnode.go

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 削除処理の具体的な対象ファイルリストが未確認

## 6) レビュアーチェックリスト（最小）
- [ ] phases/reset/ディレクトリの各フェーズ実装を確認
- [ ] CleanupNodeフェーズの具体的な削除対象を確認
- [ ] CNIクリーンアップが手動である旨の記載が正確か確認
